#ifndef HARDWARE_H
#define HARDWARE_H

#include <stdint.h>

void initHardware();

#define BUFFER_SIZE 256

// called, if more samples for the DAC are needed
void onFillSamples(uint32_t* samples, uint32_t count);

// called, if samples from the ADC are received
void onSamplesReceived(uint32_t* samples, uint32_t count);

// called at 1 kHz
void tick();

// return time since start in microseconds
uint32_t getTime();

void resetTime();

void setGreenLed(int state);

int isUserButtonPressed();

void setPortD(uint32_t bits);

int uartIsCharAvailable();

uint8_t uartGetChar();

#endif
