#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "hardware.h"
#include "kiss_fft.h"


#include "stm32f4_discovery.h"
#include "stm32f4xx_tim.h"

volatile int g_milliseconds = 0;

#define RINGBUFFER_SIZE (4 * BUFFER_SIZE)
uint32_t g_ringbuffer[RINGBUFFER_SIZE];
int g_ringbufferReadIndex = 0;
int g_ringbufferWriteIndex = 0;

// called at 1 kHz
void tick()
{
	g_milliseconds++;
	if (g_milliseconds > 500) {
		setGreenLed(1);
	} else {
		setGreenLed(0);
	}
	if (g_milliseconds == 1000) g_milliseconds = 0;
}

void onFillSamples(uint32_t* samples, uint32_t count)
{
	int i;
	for (i = 0; i < count; i++) {
		samples[i] = g_ringbuffer[g_ringbufferReadIndex++];
		if (g_ringbufferReadIndex == RINGBUFFER_SIZE) g_ringbufferReadIndex = 0;
	}
}

void onSamplesReceived(uint32_t* samples, uint32_t count)
{
	static int c = 0;
	int i;
	for (i = 0; i < count; i++) {
		g_ringbuffer[g_ringbufferWriteIndex++] = samples[i];
		if (g_ringbufferWriteIndex == RINGBUFFER_SIZE) g_ringbufferWriteIndex = 0;
		if (c++ >= 192000) {
			//static int tick = 0;
			//printf(++tick&1 ? "tick\n" : "tack\n");
			c = 0;
		}
	}
}


#define MAX_FFT_SIZE 2048

kiss_fft_cfg mycfg;
kiss_fft_cpx fin[MAX_FFT_SIZE];
kiss_fft_cpx fout[MAX_FFT_SIZE];

void startTimer()
{
    resetTime();
}

int getMilliseconds()
{
    return getTime() / 1000;
}

void testFFT(int size, int do_dB)
{
	mycfg = kiss_fft_alloc(size, size, NULL, NULL);
	float sum = 0;
	int count = 10000;
	int c;
	startTimer();
	for (c = 0; c < count; c++) {
		int j;
		for (j = 0; j < size; j++) {
			fin[j].r = c + j;
			fin[j].i = c * j * 0.1f;
		}
		kiss_fft(mycfg, fin, fout);
		if (do_dB) {
			for (j = 0; j < size; j++) {
				float r = fout[j].r;
				float i = fout[j].i;
				sum += 10 * log10f(r * r + i * i);  // == 20 * log10(sqrt(..))
			}
		} else {
			for (j = 0; j < size; j++) {
				sum += fout[j].r;
				sum += fout[j].i;
			}
		}
	}
	int ms = getMilliseconds();
	printf("size: %i, time: %f ms, with dB: %s, sum: %f\n", size, ((float) ms) / ((float) count), do_dB ? "yes" : "no", sum);
}

int main()
{
	int i;
	for (i = 0; i < RINGBUFFER_SIZE / 2; i++) {
		g_ringbuffer[g_ringbufferWriteIndex++] = 0;
	}
	initHardware();
	printf("hardware initialized\n");
	int size = 256;
	while (1) {
		testFFT(size, 0);
		testFFT(size, 1);
		size *= 2;
		if (size > MAX_FFT_SIZE) break;
	}
	printf("test end\n");
	return 0;
}
