
#include	"extern.h"

Out0	BIT	PA.3;

const WORD levels[] = { 0x010f, 0x011f, 0x017f, 0x0100 };
// const WORD levels[] = { 0x020f, 0x021f, 0x027f, 0x0200 };

WORD address;

void read_rom()
{
	WORD tmp;

	// init tmp with stack pointer and increment sp by 2
	mov a, sp
	mov lb@tmp, a
	clear hb@tmp
	add a, 2
	mov sp, a

	// save address on stack
	mov a, lb@address
	idxm tmp, a
	inc lb@tmp
	mov a, hb@address
	idxm tmp, a

	dec lb@tmp
	idxm a, tmp
	inc lb@tmp
	idxm a, tmp

	// implicit "ret" jumps to address, and then the table lookup is done with "ret a"
}

void	FPPA0 (void) : stack = 2
{
	.ADJUST_IC	SYSCLK=IHRC/32, IHRC=16MHz, VDD=3V, Bandgap=Off;

	// set pins to output
	$	Out0	High, Out;

	tm2ct = 0x00;
	tm2s = 0b0_00_00000;
	tm2c = 0b0001_1010;

	while (1) {
		BYTE i = 0;
		while (1)
		{
			address = &levels[0] + i;
#if 1
			read_rom();
			tm2b = A;
#else
			switch (i) {
				case 0:
					tm2b = 0x0f;
					break;
				case 1:
					tm2b = 0x1f;
					break;
				case 2:
					tm2b = 0x7f;
					break;
				case 3:
					tm2b = 0;
					break;
			}
#endif
			i++;
			if (i == 4) break;
			.delay 40000;
		}
		.delay 1000000;
	}
}
